# number of timesteps to iterate the model
t_max = 15

# initial population size
N0 = 20

# intrinsic population growth rate
r = 0.8

# carrying capacity
K = 100

# values of time at which to evaluate the population size
ts = seq(0,t_max,length.out=1000)
# use the solution for N(t) to calculate population sizes
Ns = N0*K*exp(r*ts)/(K-N0*(1-exp(r*ts)))

plot(ts,Ns,type='l',xlab='t',ylab='N') 
  
ts = c(0,2:25)
Ns = c(2,14,34,56,94,189,266,330,416,507,580,610,513,593,
  557,560,522,565,517,500,585,500,495,525,510)
points(ts,Ns)
